function getProject(name) {
    const p = projects[name]
    if (!p) {
        projects[name] = {name, events: []}
        return projects[name]
    } else {
        return p
    }
}

function pushEvent(projectName, event) {
    const project = getProject(projectName)
    event.entity.instance = "sample-issue-tracker:1"
    event.position = (project.events.length + 1).toString()
    project.events.push(event)
}

function upsertIssue(project, key, summary, status, assignee) {
    pushEvent(project, {
        type: "Upsert",
        entity: {
            type: "issue",
            id: key,
        },
        fields: {key, summary, status},
        references: assignee ? [{type: "user", instance: project, id: assignee}] : [],
    })
}

function deleteIssue(project, key) {
    pushEvent(project, {
        type: "Delete",
        entity: {
            type: "issue",
            id: key,
        },
    })
}

function upsertUser(project, id, name, email) {
    pushEvent(project, {
        type: "Upsert",
        entity: {
            type: "user",
            id,
        },
        fields: {id, name, email},
    })
}

const projects = {
    name: "Greenhouse",
    events: [],
}

const dataSources = {}

module.exports.getDataSources = () => {
    return Object.keys(dataSources)
}

module.exports.upsertDataSource = (id, projectName) => {
    dataSources[id] = {projectName}
}

module.exports.deleteDataSource = (id) => {
    delete dataSources[id]
}

module.exports.getDataSource = (id) => {
    return dataSources[id]?.projectName
}
module.exports.getEvents = (id) => {
    const projectName = dataSources[id]?.projectName
    if (!projectName) return null
    return projects[projectName]?.events
}
module.exports.getEventsForProjects = (projectName) => {
    return projects[projectName]?.events
}
module.exports.upsertIssue = upsertIssue
module.exports.deleteIssue = deleteIssue

/** some initial datas */
module.exports.upsertDataSource("795a9b0b-cdff-4443-a10b-cd46e1b31144", "Greenhouse")
upsertIssue("Greenhouse", "ISS-1", "Buy food", "Open")
upsertIssue("Greenhouse", "ISS-2", "Feed cat", "In Progress")
upsertUser("Greenhouse", "u1", "John Doe", "john.doe@example.local")
upsertIssue("Greenhouse", "ISS-3", "Garden not green", "Open")
upsertIssue("Greenhouse", "ISS-4", "Paint fnc", "Open")
upsertIssue("Greenhouse", "ISS-2", "Feed cat", "In Progress", "u1")
deleteIssue("Greenhouse", "ISS-3")
upsertIssue("Greenhouse", "ISS-4", "Paint fence", "Done")
