const express = require("express")
const repo = require("../services/repo")

const router = new express.Router()

router.get("/", (req, res) => {
    const dss = repo.getDataSources()
    res.status(200).send(`
        <!DOCTYPE html>
        <html lang="en">
        <body>
            <h1>Sample Issue Tracker</h1>
            <h2>Data Sources</h2>
            <ul>
            ${dss.map((ds) => `<li>${ds}: <a href="project/${repo.getDataSource(ds)}">${repo.getDataSource(ds)}</a></li>`).join("\n")}
            <ul>
        </body>
        </html>
    `)
})

router.get("/project/:name", async (req, res, next) => {
    const projectName = req.params.name
    const events = repo.getEventsForProjects(projectName) ?? []
    res.status(200).send(`
    <!DOCTYPE html>
    <html lang="en">
    <body>
        <h1>Project: ${projectName}</h1>
        <h2>Upsert Issue</h2>
        <form method="POST" action="${projectName}/issue/upsert">
            <input type="text" name="key" placeholder="Issue Key">
            <input type="text" name="summary" placeholder="Summary">
            
            <input type="text" name="status" placeholder="Issue Status">
            <input type="submit" value="Submit">
        </form>
        <h2>Delete Issue</h2>
        <form method="POST" action="${projectName}/issue/delete">
            <input type="text" name="key" placeholder="Issue Key">
            <input type="submit" value="Submit">
        </form>
        
        <h2>Events</h2>
        <ul>
        ${[...events]
            .reverse()
            .map((e) => `<li>${JSON.stringify(e)}</li>`)
            .join("\n")}
        </ul>
    </body>
    </html>
    `)
})

router.post("/project/:name/issue/upsert", async (req, res, next) => {
    const projectName = req.params.name
    const {key, summary, status} = req.body
    repo.upsertIssue(projectName, key, summary, status)
    res.redirect(`/ui/project/${projectName}`)
})
router.post("/project/:name/issue/delete", async (req, res, next) => {
    const projectName = req.params.name
    const {key} = req.body
    repo.deleteIssue(projectName, key)
    res.redirect(`/ui/project/${projectName}`)
})

module.exports = router
